<?php
/**
 * @var $article \Modules\Main\Entities\Article
 */

?>

@extends($ajax ? 'layouts.modal' : 'layouts.main')

@section('page-title',  $article->title)
@section('keywords',    '')
@section('description', '')
@section('header-class', $article->luminance ? ' headerBlue' : '')

@section('content')

<div class="case case1 news-open case--active news1 {{ $article->short ? 'news-little' : 'news-blue' }}" data-slide="1">
    @if(!$ajax)
        <div class="mainImgCase{{ $article->luminance ? ' imgLight' : '' }}" style="background-image: url({{ getImagePath($article->image, 900, 1200, 'crop') }})"></div>
    @endif
    <div class="case__descr">
        @if(!$ajax)
        <a href="/news/" class="case__back">
            <img class="case__back-icon" src="/images/general/arrow-left.svg" alt=""><span class="case__back-text">НАЗАД</span>
        </a>
        @else
        <button class="case__back">
            <img class="case__back-icon" src="/images/general/arrow-left.svg" alt=""><span class="case__back-text">НАЗАД</span>
        </button>
        @endif
        <div class="page-news_newsDetal">
            <p class="time">{{ date('d.m.Y', strtotime($article->date ))}}</p>
            <h1>{{ $article->title }}</h1>
            <div class="text">
                {!! $article->content ?: $article->anons !!}
            </div>
        </div>
        @if(!$article->short)
        <button class="case__more">
            <img class="case__more-icon" src="/images/general/arrow-left.svg" alt="">
            <div class="case__more-text">ПОДРОБНЕЕ</div>
        </button>
        @elseif($article->link)
        <a href="{{ $article->link }}" class="linkNews" target="_blank">{{ $article->link }}</a>
        @endif
    </div>

    @if(!$article->short && $article->blocks->isNotEmpty())

        @if($article->main_image)
            <img class="case__cup" src="/images/general/cup.svg" alt="">
            <img class="news__bigImg" src="{{ getImagePath($article->main_image, 1600, 650, 'crop') }}" alt="">
        @endif

        @foreach($article->blocks as $block)

            @switch($block->type)

                @case(\Modules\Main\Entities\Block::TYPE_SIMPLE_TEXT)

                <div class="case__paragraph">
                    <h3 class="case__paragraph-title animatedOpacity">{{ $block->title }}</h3>
                    <div class="case__paragraph-text animatedOpacity">{!! $block->content1 !!}</div>
                </div>

                @break

                @case(\Modules\Main\Entities\Block::TYPE_TASK_DECISION)
                <div class="case__paragraph-with-side animatedOpacity">
                    <div class="case__paragraph-with-side-caption">ЗАДАЧА:</div>
                    <div class="case__paragraph-with-side-right">
                        <div class="case__paragraph-with-side-text">{!! $block->content1 !!}</div>
                    </div>
                </div>
                <div class="case__paragraph-with-side animatedOpacity">
                    <div class="case__paragraph-with-side-caption">РЕШЕНИЕ:</div>
                    <div class="case__paragraph-with-side-right">
                        <div class="case__paragraph-with-side-title">{{ $block->title }}</div>
                        <div class="case__paragraph-with-side-text">{!! $block->content2 !!}</div>
                    </div>
                </div>
                @break

                @case(\Modules\Main\Entities\Block::TYPE_RESULT)
                <div class="case__paragraph-with-side animatedOpacity">
                    <div class="case__paragraph-with-side-caption">РЕЗУЛЬТАТ:</div>
                    <div class="case__paragraph-with-side-right">
                        <div class="case__paragraph-with-side-title">{{ $block->title }}</div>
                        <div class="case__paragraph-with-side-text">{!! $block->content1 !!}</div>
                    </div>
                </div>
                @break

                @case(\Modules\Main\Entities\Block::TYPE_GALLERY)
                <div class="case__slider animatedOpacity">
                    <div class="case__slider-frame">
                        @foreach($block->images as $image)
                        <div class="case__slider-item" style="background-image: url({{ getImagePath($image->image, 1440, 620, 'crop') }})"></div>
                        @endforeach
                    </div>
                    <div class="case__slider-palatno"></div>
                    <div class="case__slider-arrows">
                        <button class="case__slider-arrows-item case__slider-arrows-item--left">
                            <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="case__slider-arrows-svg">
                        <style type="text/css">
                            .st13 {
                                clip-path: url(#SVGID_4_1l);
                                fill: #e6007e;
                            }
                        </style>
                                <g id="group">
                                    <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow2" />
                                    <g>
                                        <defs>
                                            <path id="SVGID_3_1l" class="clip2" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                                        </defs>
                                        <clipPath id="SVGID_4_1l">
                                            <use xlink:href="#SVGID_3_1l" />
                                        </clipPath>
                                        <path class="st13" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                                    </g>
                                </g>
                    </svg>

                        </button>
                        <button class="case__slider-arrows-item case__slider-arrows-item--right">
                            <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="case__slider-arrows-svg">
                        <style type="text/css">
                            .st14 {
                                clip-path: url(#SVGID_5_1r);
                                fill: #e6007e;
                            }
                        </style>
                                <g id="group">
                                    <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow2" />
                                    <g>
                                        <defs>
                                            <path id="SVGID_4_1r" class="clip2" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                                        </defs>
                                        <clipPath id="SVGID_5_1r">
                                            <use xlink:href="#SVGID_4_1r" />
                                        </clipPath>
                                        <path class="st14" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                                    </g>
                                </g>
                    </svg>

                        </button>
                    </div>
                </div>
                @break

                @case(\Modules\Main\Entities\Block::TYPE_VIDEO)
                <div class="case__video animatedOpacity" data-ajax-url="{{ $block->image ? getImagePath($block->image) : '' }}">
                    <div class="case__video-frame"></div>
                    <button class="case__video-button" data-video="{{ $block->video }}">
                        <div class="case__video-button-icon"></div>
                    </button>
                </div>
                @break

            @endswitch

        @endforeach

        @if($same->isNotEmpty())
            <div class="case__other-cases animatedOpacity">
                @foreach($same as $article)
                    <a href="/news/{{ $article->slug }}" class="case__other-cases-item">
                        <div class="case__other-cases-item-img"  style="background-image: url({{ getImagePath($article->image, 600, 600, 'crop') }})"></div>
                        <div class="case__other-cases-item-text">{{ $article->title }}</div>
                        <div class="case__other-cases-item-button">ЧИТАТЬ</div>
                    </a>
                @endforeach
            </div>
        @endif

    @endif

</div>

@endsection