<?php
/**
 * @var $articles \Modules\Main\Entities\Article[]
*/
?>
@extends('layouts.main')

@section('page-title',  'Новости')
@section('keywords',    '')
@section('description', '')

@section('content')

    <div class="page-cases page-news">

        <div class="page-cases__slider">
            @php($i=0)
            @foreach($articles as $article)
            <div class="page-cases__slider-item" data-link="{{ route('news.show', ['slug' => $article->slug], false) }}">
                <div class="img{{ $article->luminance ? ' imgLight' : '' }}" data-ajax-url="{{ getImagePath($article->image, 900, 1200, 'crop') }}"></div>
                <a class="page-cases__read-open" href="{{ route('news.show', ['slug' => $article->slug], false) }}"></a>
                @if(!$article->short && $article->sticker)
                <img src="/images/general/{{ $article->sticker }}.svg" class="imgMin" alt="">
                @endif
            </div>
            @php($i++)
            @endforeach
        </div>
        <div class="page-cases__arrows">
            <button class="page-cases__arrows-item page-cases__arrows-item--disabled page-cases__arrows-item--left">
                <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="page-cases__arrows-svg">
                            <style type="text/css">
                                .cst1 {
                                    clip-path: url(#cSVGID_2_);
                                    fill: #e6007e;
                                }
                            </style>
                    <g id="group">
                        <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow" />
                        <g>
                            <defs>
                                <path id="cSVGID_1_" class="clip" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" style="transform: translateX(-10px);"/>
                            </defs>
                            <clipPath id="cSVGID_2_">
                                <use xlink:href="#cSVGID_1_" />
                            </clipPath>
                            <path class="cst1" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                        </g>
                    </g>
                        </svg>

            </button>
            <button class="page-cases__arrows-item page-cases__arrows-item--right">
                <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="page-cases__arrows-svg">
                            <style type="text/css">
                                .cst2 {
                                    clip-path: url(#cSVGID_4_);
                                    fill: #e6007e;
                                }
                            </style>
                    <g id="group">
                        <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow" />
                        <g>
                            <defs>
                                <path id="cSVGID_3_" class="clip" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" style="transform: translateX(-10px);"/>
                            </defs>
                            <clipPath id="cSVGID_4_">
                                <use xlink:href="#cSVGID_3_" />
                            </clipPath>
                            <path class="cst2" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                        </g>
                    </g>
                        </svg>

            </button>
        </div>
        <div class="page-cases__pagination">
            <div class="page-cases__pagination-counter">01</div>
            <div class="page-cases__pagination-indicator">
                <div class="page-cases__pagination-caret"></div>
            </div>
            <div class="page-cases__pagination-number"></div>
        </div>
        <div class="page-cases__read-button" data-text="ЧИТАТЬ">ЧИТАТЬ</div>
        <div class="page-cases__descr">

            @php($i=0)
            @foreach($articles as $article)
            <div class="page-cases__descr-item {{ $i ? '' : 'page-cases__descr-item--active' }}">
                <div class="page-news_slider">
                    <p class="time">{{ date('d.m.Y', strtotime($article->date)) }}</p>
                    <h1>{{ $article->title }}</h1>
                    <div class="text">
                        {!! $article->anons !!}
                    </div>
                </div>
            </div>
            @php($i++)
            @endforeach
        </div>
    </div>
    <div class="cases"></div>

@endsection