<?php
/**
 * @var $page[]
*/
?>
@extends('layouts.main')

@section('page-title',  $page['seo_title'])
@section('keywords',    $page['seo_keywords'])
@section('description', $page['seo_description'])
@section('body-class',  'maps')

@section('content')

    <div class="page-maps">
        <div class="page-maps--wrapp">
            <div class="contacts">
                <dl class="col">
                    <dt>АДРЕС:</dt>
                    <dd>{!! nl2br($page['address']) !!}</dd>
                </dl>
                <a href="#" class="bt" data-fancybox="inline" data-src="#address" href="javascript:;">КАК ДОБРАТЬСЯ</a>
                <dl class="col">
                    <dt>Телефон:</dt>
                    <dd>
                        <a href="tel:{{ preg_replace('/\D\+/', '', $page['phone1']) }}">{{ $page['phone1'] }}</a>
                        <a href="tel:{{ preg_replace('/\D\+/', '', $page['phone2']) }}">{{ $page['phone2'] }}</a>
                    </dd>
                </dl>
                <div class="box">
                    @if($page['email_tender'])
                    <dl class="col2">
                        <dt>Пригласить в тендер</dt>
                        <dd><a href="mailto:{{ $page['email_tender'] }}" class="mail">{{ $page['email_tender'] }}</a></dd>
                    </dl>
                    @endif
                    @if($page['email_common'])
                    <dl class="col2">
                        <dt>По общим вопросам</dt>
                        <dd><a href="mailto:{{ $page['email_common'] }}" class="mail">{{ $page['email_common'] }}</a></dd>
                    </dl>
                    @endif
                    @if($page['email_hr'])
                    <dl class="col2">
                        <dt>Хочу работать у вас</dt>
                        <dd><a href="mailto:{{ $page['email_hr'] }}" class="mail">{{ $page['email_hr'] }}</a></dd>
                    </dl>
                    @endif
                    @if($page['email_pr'])
                    <dl class="col2">
                        <dt>По вопросам PR и спикерства</dt>
                        <dd><a href="mailto:{{ $page['email_pr'] }}" class="mail">{{ $page['email_pr'] }}</a></dd>
                    </dl>
                    @endif
                </div>
            </div>
            <div class="mapContainer">
                <div class="map" id="map" data-x="{{ trim($coordinates[0]) }}" data-y="{{ trim($coordinates[1]) }}">
                </div>
            </div>
        </div>
    </div>
    <div id="address" class="fancy" style="display: none;">
        <p class="title">КАК ДОБРАТЬСЯ:</p>
        {!! $page['route'] !!}
    </div>

@endsection
<script src="https://api-maps.yandex.ru/2.1/?lang=ru_RU" type="text/javascript"></script>
@push('scripts')

@endpush