<?php
/**
 * @var $page[]
*/
?>
@extends('layouts.main')

@section('page-title',  $page['seo_title'] ? $page['seo_title'] : $page['title'])
@section('keywords',    $page['seo_keywords'])
@section('description', $page['seo_description'])

@section('content')

    <div class="page-about ">
        <div class="page-about--wrapp">
            <div class="container">
                <div class="text">
                    <p class="title"><span>{!! $page['title'] !!}</span></p>
                    <p class="titleLittle">{!! $page['sub_title'] !!}</p>
                    <p>
                        {!! nl2br($page['text']) !!}
                    </p>
                </div>
                <div class="img"><img src="{{ getImagePath($page['image'], 900, 1200, 'crop') }}" alt=""></div>
            </div>
            <div class="svgHand">
                <img src="/images/general/hand.svg" alt="">
                <p>
                    {!! nl2br($page['blockquote']) !!}
                </p>
            </div>
            <a href="#" class="btMovie btMovie--about">
                <i class="bg"></i>
                <span>MOVIE В ЦИФРАХ</span>
            </a>
        </div>
        <div class="page-about-mov--wrapp">
            <div class="container">
                <div class="titleBox">
                    <p class="title"><span>MOVIE</span></p>
                    <p class="title"><span>В ЦИФРАХ</span></p>
                </div>
                <div class="circleBigBox">
                    <div class="circleBig">
                        <div class="textNumber">
                            <p class="titleB"><span>{!! $page['numbers_main'] !!}</p>
                            <p class="little">{!! nl2br($page['numbers_main_caption']) !!}</p>
                        </div>
                        <svg class="circle-chart" viewBox="0 0 33.83098862 33.83098862" xmlns="http://www.w3.org/2000/svg">
                            <circle class="circle-chart__circle success-stroke" stroke-dasharray="67.8,100" cx="16.9" cy="16.9" r="14.1"></circle>
                        </svg>
                    </div>
                </div>
                <div class="circleBox">
                    <div class="circleLittle pink">
                        <div class="textNumber">
                            <p class="titleB"><span>{!! $page['numbers_n1']!!}</span></p>
                            <p class="little">{!! nl2br($page['numbers_n1_caption']) !!}</p>
                        </div>
                        <img src="/images/cir-line-pink.svg" class="circle" alt="">
                        <svg class="circle-chart" viewBox="0 0 33.83098862 33.83098862" xmlns="http://www.w3.org/2000/svg">
                            <circle class="circle-chart__circle success-stroke" stroke-dasharray="67.8,100" cx="16.9" cy="16.9" r="13.4"></circle>
                        </svg>
                    </div>
                    <div class="circleLittle orange">
                        <div class="textNumber">
                            <p class="titleB"><span>{!! $page['numbers_n2']!!}</span></p>
                            <p class="little">{!! nl2br($page['numbers_n2_caption']) !!}</p>
                        </div>
                        <img src="/images/cir-line-orange.svg" class="circle" alt="">
                        <svg class="circle-chart" viewBox="0 0 33.83098862 33.83098862" xmlns="http://www.w3.org/2000/svg">
                            <circle class="circle-chart__circle success-stroke" stroke-dasharray="67.8,100" cx="16.9" cy="16.9" r="13.4"></circle>
                        </svg>
                    </div>
                    <div class="circleLittle turquoise">
                        <div class="textNumber">
                            <p class="titleB"><span>{!! $page['numbers_n3']!!}</span></p>
                            <p class="little">{!! nl2br($page['numbers_n3_caption']) !!}</p>
                        </div>
                        <img src="/images/cir-line-turquoise.svg" class="circle" alt="">
                        <svg class="circle-chart" viewBox="0 0 33.83098862 33.83098862" xmlns="http://www.w3.org/2000/svg">
                            <circle class="circle-chart__circle success-stroke" stroke-dasharray="67.8,100" cx="16.9" cy="16.9" r="13.4"></circle>
                        </svg>
                    </div>
                </div>
            </div>
            <a href="#" class="btMovie btMovie--who">
                <i class="bg"></i>
                <span>КТО МЫ</span>
            </a>
        </div>
    </div>

@endsection