<?php
/**
 * @var $cases \Modules\Main\Entities\CCase[]
*/
?>
@extends('layouts.main')

@section('page-title',  'Новости')
@section('keywords',    '')
@section('description', '')

@section('content')

    <main class="page__main _full">
        <div class="slider inner">
            <div class="slider__container js-home-slider swiper-container">
                <div class="slider__inner swiper-wrapper">
                    @php($i=0)
                    @foreach($articles as $article)
                    <div class="slider__slide swiper-slide">
                        <div class="slider__header _min">
                            <a href="{{ route('news.show', ['slug' => $article->slug]) }}" class="slider__bg" style="background-image: url({{ getImagePath($article->image, 450, 400, 'crop') }})"></a>
                        </div>
                        <div class="slider__wrap">
                            <div class="slider__content">
                                <div class="slider__inner">
                                    <div class="slider-info _arrow">
                                        <button type="button" class="slider-arrow__next js-home-slider-next"></button>
                                        <div class="slider-info__content">
                                            <div class="slider-info__data">{{ date('d.m.Y', strtotime($article->date)) }}</div>
                                            <div class="slider-info__title">{{ $article->title }}</div>
                                            <div class="slider-info__desc">
                                                {!! $article->anons !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="slider__footer">
                                <div class="slider__inner">
                                    <div class="slider-pagination">
                                        <div class="slider-pagination__box">01</div>
                                        <div class="slider-pagination__slider swiper-pagination js-home-slider-pagination"></div>
                                        <div class="slider-pagination__box">{{ $articles->count() < 10 ? '0' : '' }}{{ $articles->count() }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @php($i++)
                    @endforeach
                </div>
            </div>
        </div>
    </main>

@endsection