<?php
/**
 * @var $case \Modules\Main\Entities\CCase
*/
?>
@extends('layouts.main')

@section('page-title',  $case->title)
@section('keywords',    '')
@section('description', '')

@section('content')

    <main class="page__main">
        <div class="page__content">
            <div class="page__inner inner">
                <div class="page__back back">
                    <a href="{{ route('cases') }}" class="back__link">НАЗАД</a>
                </div>
                <div class="post">
                    <div class="post__img">
                        <img src="{{ getImagePath($case->image, 400, 450, 'crop') }}" alt="">
                        <div class="post__status">
                            <img src="/mobile/img/heart.svg" alt="">
                        </div>
                        <div class="post__info">
                            <div class="post__name">
                                {{ $case->title }}
                            </div>
                            <div class="post-tags">
                                <div class="post-tags__wrapper">
                                    @foreach($case->tags as $tag)
                                        <a class="post-tags__box" href="#">#{{ $tag->title }}</a>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="post-params">
                        <div class="post-params__inner">
                            <div class="post-params__wrapper flex flex--wrap w-100">
                                @if($case->brand)
                                <div class="post-params__box w-50">
                                    <div class="post-params__item">
                                        <div class="post-params__name">БРЕНД:</div>
                                        <div class="post-params__value">{{ $case->brand }}</div>
                                    </div>
                                </div>
                                @endif
                                @if($case->agency)
                                <div class="post-params__box w-50">
                                    <div class="post-params__item">
                                        <div class="post-params__name">КЕЙС:</div>
                                        <div class="post-params__value">{{ $case->agency }}</div>
                                    </div>
                                </div>
                                @endif
                                @if($case->anons)
                                <div class="post-params__box w-100">
                                    <div class="post-params__item">
                                        <div class="post-params__name">СУТЬ:</div>
                                        <div class="post-params__value">
                                            {!! $case->anons !!}
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    @foreach($case->blocks as $block)

                        @switch($block->type)

                            @case(\Modules\Main\Entities\Block::TYPE_SIMPLE_TEXT)

                            <div class="typography">
                                <h2>{{ $block->title }}</h2>
                                <p>{!! $block->content1 !!}</p>
                            </div>

                            @break

                            @case(\Modules\Main\Entities\Block::TYPE_TASK_DECISION)
                            <div class="typography">
                                <span class="name">ЗАДАЧА:</span>
                                {!! $block->content1 !!}
                            </div>
                            <div class="typography">
                                <span class="name">РЕШЕНИЕ:</span>
                                <h2>{{ $block->title }}</h2>
                                {!! $block->content2 !!}
                            </div>
                            @break

                            @case(\Modules\Main\Entities\Block::TYPE_RESULT)
                            <div class="typography">
                                <span class="name">РЕЗУЛЬТАТ:</span>
                                <h2>{{ $block->title }}</h2>
                                <p>{!! $block->content1 !!}</p>
                            </div>
                            @break

                            @case(\Modules\Main\Entities\Block::TYPE_GALLERY)
                            <div class="post-slider">
                                <div class="post-slider__container js-slider-easy swiper-container">
                                    <div class="post-slider__wrapper swiper-wrapper">
                                        @foreach($block->images as $image)
                                        <div class="post-slider__box swiper-slide">
                                            <div class="post-slider__item">
                                                <img src="{{ getImagePath($image->image, 1440, 620, 'crop') }}" alt="">
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                    <div class="post-slider__arrow">
                                        <button type="button" class="post-slider__arrow-item _prev js-slider-easy-prev"></button>
                                        <button type="button" class="post-slider__arrow-item _next js-slider-easy-next"></button>
                                    </div>
                                </div>
                            </div>

                            @break

                            @case(\Modules\Main\Entities\Block::TYPE_VIDEO)
                            <div class="post-video">
                                <a href="{{ $block->video }}" data-fancybox="video" class="post-video__link">
                                    @if($block->image)
                                    <img src="{{ getImagePath($block->image) }}" alt="">
                                    @endif
                                </a>
                            </div>
                            @break

                        @endswitch

                    @endforeach

                </div>
                <div class="c-nav">
                    <div class="c-nav__inner">
                        <div class="c-nav__wrapper">
                            <div class="c-nav__box">
                                @if($case->previous())
                                <a href="{{ route('case.show', ['slug' => $case->previous()->slug]) }}" class="c-nav__link _prev">ПРЕДЫДУЩИЙ КЕЙС</a>
                                @endif
                            </div>
                            <div class="c-nav__box">
                                @if($case->next())
                                <a href="{{ route('case.show', ['slug' => $case->next()->slug]) }}" class="c-nav__link _next">СЛЕДУЮЩИЙ КЕЙС</a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

@endsection