<?php
/**
 * @var $cases \Modules\Main\Entities\CCase[]
*/
?>
@extends('layouts.main')

@section('page-title',  'Кейсы')
@section('keywords',    '')
@section('description', '')

@section('content')

    <main class="page__main _full">
        <div class="slider inner">
            <div class="slider__container js-home-slider swiper-container">
                <div class="slider__inner swiper-wrapper">
                    @foreach($cases as $case)
                    <div class="slider__slide swiper-slide">
                        <div class="slider__header _min">
                            <a href="{{ route('case.show', ['slug' => $case->slug], false) }}" class="slider__bg" style="background-image: url({{ getImagePath($case->image, 400, 450, 'crop') }})"></a>
                            <div class="slider__status">
                                <img src="/mobile/img/heart.svg" alt="">
                            </div>
                            <a href="{{ route('case.show', ['slug' => $case->slug], false) }}" class="slider__full-btn">СМОТРЕТЬ КЕЙС</a>
                            @if($case->video)
                                <a href="{{ $case->video }}" data-fancybox class="slider__video"></a>
                            @endif
                        </div>
                        <div class="slider__wrap">
                            <div class="slider__content">
                                <div class="slider__inner">
                                    <div class="slider-info _arrow">
                                        <button type="button" class="slider-arrow__next js-home-slider-next"></button>
                                        <div class="slider-info__inner">
                                            <div class="slider-info__wrapper">
                                                @if($case->title)
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">КЕЙС:</div>
                                                    <div class="slider-info__value">{{ $case->title }}</div>
                                                </div>
                                                @endif
                                                @if($case->brand)
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">БРЕНД:</div>
                                                    <div class="slider-info__value">{{ $case->brand }}</div>
                                                </div>
                                                @endif
                                                @if($case->agency)
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">АГЕНТСТВО:</div>
                                                    <div class="slider-info__value">{{ $case->agency }}</div>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="slider-tags">
                                        <div class="slider-tags__wrapper">
                                            @foreach($case->tags as $tag)
                                                <a href="#" class="slider-tags__box">#{{ $tag->title }}</a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="slider__footer">
                                <div class="slider__inner">
                                    <div class="slider-pagination">
                                        <div class="slider-pagination__box">01</div>
                                        <div class="slider-pagination__slider swiper-pagination js-home-slider-pagination"></div>
                                        <div class="slider-pagination__box">{{ $cases->count() < 10 ? '0' : '' }}{{ $cases->count() }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </main>

@endsection