<?php

namespace App\Notifications;


use Illuminate\Notifications\Messages\MailMessage;
use Modules\Notifications\Notifications\BaseNotification;

class CallBack extends BaseNotification
{
    public $callback;


    public function __construct(\Modules\Callback\Entities\Callback $callback)
    {
        $this->callback = $callback;
    }


    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage())
            ->subject('Заказ обратного звонка')
            ->greeting('Заказан обратный звонок')
            ->line('Фио: ' . $this->callback->fio)
            ->line('Телефон: ' . $this->callback->phone)
            ->line('Дата: ' . $this->callback->created_at);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toDatabase($notifiable)
    {
        return $this->callback->toArray();
    }
}
