<?php

namespace App\Notifications;


use Illuminate\Notifications\Notification;
use Modules\Users\Entities\User;
use Modules\Notifications\Entities\NotificationType;

class AdminNotify
{

    public function __construct()
    {
        //
    }

    public function notify(Notification $notification)
    {
        $type = NotificationType::where('type', get_class($notification))->first();

        if($type && $type->users->isNotEmpty()){
            try{
                \Illuminate\Support\Facades\Notification::send($type->users, $notification);
            } catch (\Exception $e){

            }
        }

    }
}