<?php
/**
 * Created by Developer.
 * User: Dmitry S.
 * Date: 25.04.2018
 * Time: 19:05
 */

namespace App\Filters;


use Illuminate\Database\Eloquent\Builder;

class ProductFilters extends QueryFilters
{
    /**
     * @param integer $artist
     *
     * @return $this
     */
    public function artist($artist)
    {
        return $this->builder->whereHas('artists', function ($query) use ($artist) {
            $query->whereIn('artist_id', $artist);
        });
    }

    /**
     * @param integer $brand
     *
     * @return $this
     */
    public function brand($brand)
    {
        return $this->builder->where('brand_id', $brand);
    }

    /**
     * Filter by product filters
     * @param $filters
     *
     * @return Builder|static
     */
    public function f($filters)
    {
        return $this->builder->whereHas('combinations', function ($query) use ($filters){
            foreach ($filters as $filter_id) {
                $query->whereHas('filters', function ($query) use ($filter_id){
                        $query->where('filter_id', $filter_id);
                });
            }
        });
    }

    /**
     * Sort
     *
     * @param  string $order
     * @return Builder
     */
    public function sort($order)
    {
        if($order == 'price'){
            return $this->builder->orderBy('price', 'asc');
        } elseif($order == 'new') {
            return $this->builder->orderBy('created_at', 'desk');
        }
    }


}