<?php

namespace Modules\Users\Entities;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Modules\Modules\Entities\Modules;
use Modules\Notifications\Entities\NotificationType;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'login', 'avatar', 'full_access', 'notify'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = bcrypt($value);
    }

    public function modules()
    {
        return $this->belongsToMany(Modules::class, 'module_user', 'user_id', 'module_id');
    }

    public function groups()
    {
        return $this->belongsToMany(Group::class);
    }

    public function notification_types()
    {
        return $this->belongsToMany(NotificationType::class);
    }

    public function is_admin()
    {
        return $this->id === 1 || $this->full_access;
    }

    public function scopeNotified($query)
    {
        return $query->where('notify', 1);
    }

    //TODO: Refactor this. Move to service
    public function has_access_to($module_name)
    {
        if($this->is_admin()){
            return true;
        }

        $module = Modules::where('name', $module_name)->first();

        if(!$module){
            return true;
        }

        if($module
           && ( $this->modules()->where('name', $module_name)->first()
           || $this->groups()->whereHas('modules', function ($query) use ($module_name) {
                $query->where('name', $module_name);
            })->first() )
        ){
            return true;
        }

        return false;
    }
}
