<?php

namespace Modules\Settings\Http\Forms;

use Kris\LaravelFormBuilder\Form;

class SettingsForm extends Form
{
    public function buildForm()
    {
        $this
            ->add('social', 'tabform', [
                'label' => 'Соц. сети',
                'class' => SettingSocialForm::class
            ])
            /*->add('seo', 'tabform', [
                'label' => 'SEO',
                'class' => SettingSeoForm::class
            ])
            ->add('contacts', 'tabform', [
                'label' => 'Контакты',
                'class' => SettingContactsForm::class
            ])*/
            ->add('coordinates', 'text', [
                'label' => 'Координаты офиса на карте',
            ])
            ->add('brief', 'file', [
                'label' => 'Brief (pdf)',
            ])
            ->add('menu_video', 'file', [
                'label' => 'Видео-подложка меню',
            ])
            ->add('blog_link', 'text', [
                'label' => 'Ссылка на блог',
            ])
            ->add('counters', 'textarea', [
                'label' => 'Счетчики'
            ])
        ;
    }

    private function addTranslatable(string $name, string $type, array $options = []) : Form
    {
        $languages = config('translatable.locales');
        foreach ($languages as $k => $language) {
            $opt = $options;
            if(isset($opt['label'])){
                $opt['label'] .= ' '.$language;
            }

            $this->add($name.'_'.$language, $type, $opt);
        }

        return $this;
    }

}
