<?php

namespace Modules\Settings\Http\Controllers;

use Modules\Settings\Http\Forms\SettingsForm;
use Modules\Settings\Entities\Settings;
use Kris\LaravelFormBuilder\FormBuilder;
use Kris\LaravelFormBuilder\FormBuilderTrait;
use Modules\Core\Http\Controllers\CrudController;
use Illuminate\Foundation\Validation\ValidatesRequests;

class SettingsController extends Controller
{
    use ValidatesRequests;
    use FormBuilderTrait;

    public function index(Settings $settings, FormBuilder $form_builder)
    {

        $values = $settings->allParams();
        $values['social'] = [
            'whatsapp' => $values['whatsapp'] ?? '',
            'viber' => $values['viber'] ?? '',
            'tg' => $values['tg'] ?? '',
            'fb' => $values['fb'] ?? '',
            'vk' => $values['vk'] ?? '',
            'ok' => $values['ok'] ?? '',
            'tw' => $values['tw'] ?? '',
            'instagram' => $values['instagram'] ?? '',
            'youtube' => $values['youtube'] ?? '',
        ];

        /*$values['seo'] = [
            'seo_title' => $values['seo_title'] ?? '',
            'seo_description' => $values['seo_description'] ?? '',
            'seo_keywords' => $values['seo_keywords'] ?? '',
        ];

        $values['contacts'] = [
            'contacts_ru' => $values['contacts_ru'] ?? '',
            'contacts_en' => $values['contacts_en'] ?? '',
            'contacts_ch' => $values['contacts_ch'] ?? '',
        ];*/

        $form = $form_builder->create(SettingsForm::class,[
            'method' => 'POST',
            'url' => route('settings.store'),
            'model' => $values
        ]);

        return view('settings::index', compact('form'));
    }

    public function store(Settings $settings)
    {
        $form = $this->form(SettingsForm::class);

        $form->redirectIfNotValid();

        $values = $form->getFieldValues();

        $social = $values['social'];
        unset($values['social']);
        $values += $social;

        /*$seo = $values['seo'];
        unset($values['seo']);
        $values += $seo;

        $contacts = $values['contacts'];
        unset($values['contacts']);
        $values += $contacts;*/

        $settings->updateParams($values);

        return redirect()->route('settings.index');
    }
}

