<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->unique();
            $table->text('value')->nullable();
        });

        DB::table('settings')->insert([
            ['name'  =>  'phone'],
            ['name'  =>  'company'],
            ['name'  =>  'copy'],
            ['name'  =>  'counters'],
            ['name'  =>  'fb'],
            ['name'  =>  'vk'],
            ['name'  =>  'ok'],
            ['name'  =>  'tw'],
            ['name'  =>  'tg'],
            ['name'  =>  'whatsapp'],
            ['name'  =>  'viber'],
            ['name'  =>  'instagram'],
            ['name'  =>  'seo_title'],
            ['name'  =>  'seo_description'],
            ['name'  =>  'seo_keywords'],
            ['name'  =>  'contacts'],
            ['name'  =>  'email'],
            ['name'  =>  'email_bottom'],
            ['name'  =>  'email_order'],
            ['name'  =>  'policy'],
        ]);

        DB::table('modules')->insert( [
            'name' => 'settings',
            'section' => 'tools',
            'title' => 'Настройки',
        ]);

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
