<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('id_parent')->default(0);
            $table->integer('pos')->default(0);
            $table->integer('level')->default(0);
            $table->tinyInteger('isparent')->default(0);
            $table->string('title');
            $table->string('path');
            $table->string('fullpath');
            $table->text('content')->nullable();
            $table->tinyInteger('hidden')->default(0);
            $table->string('seo_title')->nullable();
            $table->text('seo_description')->nullable();
            $table->text('seo_keywords')->nullable();

            $table->timestamps();
        });

        $id = DB::table('pages')->insertGetId(
            [
                'id_parent' => 0,
                'pos' => 0,
                'level' => 0,
                'isparent' => 0,
                'title' => 'Главная',
                'path' => '/',
                'fullpath' => '',
            ]
        );

        $item = DB::table('modules')->where('name', 'pages')->first();

        if(!$item){
            DB::table('modules')->insert( [
                'name' => 'pages',
                'section' => 'modules',
                'title' => 'Страницы',
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pages');

    }
}
