@extends('core::layouts.app')

@section('page-title', 'Уведомления')

@section('breadcrumb')
    @include('core::common.breadcrumb')
@endsection

@section('content')
    <div class="portlet light">
        <div class="portlet-title">

        </div>

        <div class="portlet-body">
            <div class="table-container">
                <div class="table-scrollable">
                    <table class="table table-striped table-bordered table-hover" >
                        <thead>
                        <tr role="row" class="heading">

                            <th width="1%">
                                ID
                            </th>

                            @foreach($fields as $name=>$field)
                                <th>{{ $field['title'] }}</th>
                            @endforeach

                            <th width="1%">
                                <?=_('Действия')?>
                            </th>
                        </tr>
                        </thead>
                        <tbody>

                        @foreach($notifications as $item)
                            <tr align="center" class="odd">
                                <td style="font-size:11px;color:#999;">{{ $item->id }}</td>


                                @foreach($fields as $name=>$field)
                                    <td align="left">
                                        {{ $item->$name }}
                                    </td>
                                @endforeach


                                <td nowrap="nowrap">
                                    <a class="btn btn-icon-only blue" href="{{ action($controller.'@show', $item->id) }}" title="<?=_('Смотреть')?>"><i class="fa fa-pencil"></i></a>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                {{ $items->links() }}
            </div>
        </div>


    </div>
@stop
