<?php

namespace Modules\Notifications\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Log;

abstract class BaseNotification extends Notification
{
    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $transport = ['database'];
        if($notifiable->email){
            $transport[] = 'mail';
        }
        if($notifiable->phone){
            $transport[] = 'sms';
        }


        return $transport;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    abstract public function toDatabase($notifiable);
}
