<?php

namespace Modules\Notifications\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Core\Http\Controllers\Controller;

class NotificationsController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $notifications = auth()->user()->notifications;
        return view('notifications::index', compact('notifications'));
    }

    public function clear(Request $request)
    {
        if(!$request->isXmlHttpRequest()){
            return abort(404);
        }

        auth()->user()->unreadNotifications->markAsRead();

        return ['result' => true];
    }

    public function mark_as_read(Request $request)
    {
        if(!$request->isXmlHttpRequest()){
            return abort(404);
        }

        $id = $request->request->get('id');

        auth()->user()->unreadNotifications()->where('id', $id)->update(['read_at' => Carbon::now()]);

        return ['result' => true];

    }

}
