@extends('core::layouts.app')

@section('page-title', $title)

@section('breadcrumb')
    @include('core::common.breadcrumb')
@endsection

@section('content')
    <div class="portlet light ">
        <div class="portlet-title">
            <div class="caption font-red-intense">
                <i class="icon-pin font-red-intense"></i>
                <span class="caption-subject bold uppercase">{{ $title }}</span>
            </div>

            <div class="actions btn-set">
                <a href="{{ action($controller.'@create') }}" class="btn btn-default"> Добавить</a>
                <a href="{{ action($controller.'@index') }}" class="btn btn-default"> К списку</a>
            </div>
        </div>

        <div class="portlet-body form">

            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#tab_1" data-toggle="tab">Общее</a>
                    </li>
                    @if(!(isset($item->short) && $item->short))
                    <li>
                        <a href="#tab_blocks" data-toggle="tab">Описание</a>
                    </li>
                    @endif
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1">

                        {!! form_start($form, ['class'=>'form-horizontal form-bordered form-label-stripped']) !!}
                        {!! form_rest($form) !!}
                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i> Сохранить </button>
                                    <button type="button" class="btn default" onclick="document.location = '{{ action($controller.'@index') }}'">Отмена</button>
                                </div>
                            </div>
                        </div>

                        {!! form_end($form) !!}
                    </div>

                    @if(!(isset($item->short) && $item->short))
                    <div class="tab-pane" id="tab_blocks">
                        <div class="clearfix">
                            <a href="{{ route(strtolower(class_basename($item)).'s.blocks.create', ['item' => $item->id]) }}" class="btn btn-default pull-right"> Добавить блок</a>
                        </div><br/>

                        @if($item->blocks->isNotEmpty())
                            <table class="table table-striped table-bordered table-hover" >
                                <thead>
                                <tr role="row" class="heading">
                                    <th width="1%">
                                        ID
                                    </th>
                                    <th width="1%">
                                        Поз.
                                    </th>
                                    <th>Название</th>
                                    <th>Тип</th>
                                    <th>Включено</th>

                                    <th width="1%">
                                        <?=_('Действия')?>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>

                                @foreach($item->blocks as $block)
                                    <tr align="center" class="odd">
                                        <td style="font-size:11px;color:#999;">{{ $block->id }}</td>
                                        <td class="item" id="{{ $block->pos }}" style="font-size:11px;color:#999;">
                                            <input class="inp" id="{{ $block->id }}" style="width:40px; display:none; font-size:11px; text-align:center;" type="text" value="{{ $block->pos }}" rel="{{ $block->getTable() }}" cat="" cat_val="" />
                                            <span style="display:block; width:40px;">{{ $block->pos }}</span></td>
                                        <td align="left">{{ $block->title }}</td>
                                        <td align="left">{{ \Modules\Main\Entities\Block::$types[$block->type] }}</td>
                                        <td align="left">{{ $block->act ? 'Да' : 'Нет' }}</td>
                                        <td nowrap="nowrap">
                                            <a class="btn btn-icon-only blue" href="{{ route(strtolower(class_basename($item)).'s.blocks.edit', ['case' => $item->id, 'block' => $block->id]) }}" title="<?=_('Редактировать')?>"><i class="fa fa-pencil"></i></a>
                                            <form id="del-form-{{ $block->id }}" action="{{ route(strtolower(class_basename($item)).'s.blocks.destroy', ['case' => $item->id, 'block' => $block->id]) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                            <a href="javascript:del('del-form-{{ $block->id }}')" title="<?=_('Удалить')?>" class="btn btn-icon-only red"><i class="fa fa-trash-o"></i></a>
                                        </td>
                                    </tr>
                                @endforeach

                                </tbody>
                            </table>
                        @endif
                    </div>
                    @endif

                </div>
            </div>


        </div>
    </div>
@endsection


@push('scripts')
    <script src="/admin_assets/js/sort.js" type="text/javascript"></script>
@endpush