<?php

namespace Modules\Main\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Core\Forms\SeoMetaForm;

class MainForm extends Form
{
    public function buildForm()
    {

        $this
            ->add('seo', 'tabform', [
                'label' => 'SEO',
                'class' => SeoMetaForm::class
            ])
        ;

    }

    private function addTranslatable(string $name, string $type, array $options = []) : Form
    {
        $languages = config('translatable.locales');
        foreach ($languages as $k => $language) {
            $opt = $options;
            if(count($languages)>1 && isset($opt['label'])){
                $opt['label'] .= ' '.$language;
            }

            $this->add($name.'_'.$language, $type, $opt);
        }

        return $this;
    }

}
