<?php

namespace Modules\Main\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Core\Forms\SeoMetaForm;

class ContactsForm extends Form
{
    public function buildForm()
    {
        $this
            ->add('seo', 'tabform', [
                'label' => 'SEO',
                'class' => SeoMetaForm::class
            ])
        ;

        $this
            ->add('address', 'textarea', [
                'label' => 'Адрес',
                'attr' => [
                    'rows' => 3
                ]
            ])
            ->add('phone1', 'text', [
                'label' => 'Телефон 1'
            ])
            ->add('phone2', 'text', [
                'label' => 'Телефон 2'
            ])
            ->add('email_tender', 'text', [
                'label' => 'E-mail (Пригласить в тендер)'
            ])
            ->add('email_common', 'text', [
                'label' => 'E-mail (По общим вопросам)'
            ])
            ->add('email_hr', 'text', [
                'label' => 'E-mail (Хочу работать у вас)'
            ])
            ->add('email_pr', 'text', [
                'label' => 'E-mail (По вопросам PR)'
            ])
            ->add('route', 'textarea', [
                'label' => 'Как добраться'
            ])
        ;
    }

    private function addTranslatable(string $name, string $type, array $options = []) : Form
    {
        $languages = config('translatable.locales');
        foreach ($languages as $k => $language) {
            $opt = $options;
            if(count($languages)>1 && isset($opt['label'])){
                $opt['label'] .= ' '.$language;
            }

            $this->add($name.'_'.$language, $type, $opt);
        }

        return $this;
    }

}
