<?php

namespace Modules\Main\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Main\Entities\CCase;

class ClientForm extends Form
{
    public function buildForm()
    {

        $cases = CCase::select('id', 'title')->get();

        $this
            ->add('title', 'text', [
                'label' => 'Название'
            ])
            ->add('image', 'image', [
                'label' => 'Логотип',
                'help_block' => [
                    'text' => 'Размер изображения на сайте: 312x317',
                ]
            ])
            ->add('case_id', 'choice', [
                'label' => 'Ссылка на кейс',
                'choices' => ['' => '- Выберите кейс -'] + \Arr::pluck($cases,'title','id'),
                'choice_options' => [
                    'wrapper' => ['class' => 'choice-wrapper'],
                    'label_attr' => ['class' => 'label-class'],
                ],
            ])
            ->add('link', 'text', [
                'label' => 'Произвольная ссылка'
            ])
            ->add('act', 'checkbox', [
                'label' => 'Показывать'
            ])
            ;
    }
}