<?php

namespace Modules\Main\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Kris\LaravelFormBuilder\FormBuilderTrait;
use Kris\LaravelFormBuilder\FormBuilder;
use Modules\Main\Entities\Main;
use Modules\Main\Http\Forms\MainForm;

class MainController extends Controller
{
    use ValidatesRequests;
    use FormBuilderTrait;

    protected $tabs = ['seo'];

    public function index(Main $main, FormBuilder $form_builder)
    {

        $values = $main->allParams();

        foreach($this->tabs as $tab) {
            $values[$tab] = array();
            foreach($values as $i=>$value) {
                if(strpos($i, $tab.'_') === 0) {
                    $values[$tab][$i] = $value;
                }
            }
        }

        $form = $form_builder->create(MainForm::class,[
            'method' => 'POST',
            'url' => route('main.store'),
            'model' => $values
        ]);

        return view('main::about', compact('form'));
    }

    public function store(Main $main)
    {

        $form = $this->form(MainForm::class);

        // It will automatically use current request, get the rules, and do the validation
        if (!$form->isValid()) {
            return redirect()->back()->withErrors($form->getErrors())->withInput();
        }

        $form->redirectIfNotValid();

        $values = $form->getFieldValues();

        foreach($this->tabs as $tab) {
            if(isset($values[$tab])) {
                $values += $values[$tab];
                unset($values[$tab]);
            }
        }

        $main->updateParams($values);

        return redirect()->route('main.index');
    }
}
