<?php

namespace Modules\Main\Entities;

use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    protected $fillable = ['title'];
    public $timestamps = false;

    public function cases()
    {
        return $this->belongsToMany(CCase::class);
    }

    public function getTitleAttribute()
    {
        return mb_strtoupper($this->attributes['title'], 'UTF-8');
    }

}
