<?php

namespace Modules\Main\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Cache;

class Contacts extends Model
{
    public $fillable = ['name', 'value'];
    protected  $table = 'contacts';
    public $timestamps = false;
    static $params;


    public function updateParams(array $params)
    {
        foreach ($params as $key=>$value) {
            $item = $this->firstOrCreate(['name'=>$key]);
            $item->value = $value;
            $item->save();
        }
    }


    public static function getAllParams()
    {
        if(!static::$params){

            static::$params = static::allParams();

        }

        return static::$params;
    }


    public static function allParams()
    {
        $params = [];
        $list = Contacts::all();
        foreach ($list as $item) {
            $params[$item['name']] = $item['value'];
        }

        return $params;
    }


    public function get($name)
    {
        $params = $this->getAllParams();

        return isset($params[$name]) ? $params[$name]:'';
    }


    public function set($name, $value)
    {
        if(static::$params){

            static::$params[$name] = $value;

        }
    }


    public function getTranslated($name)
    {
        $params = $this->getAllParams();
        $lang = app()->getLocale();
        $lang = app()->getLocale();

        $l_name = $name.'_'.$lang;
        $l_name_default = $name.'_'.config('app.default_locale');

        return isset($params[$l_name]) && $params[$l_name] ? $params[$l_name] : $params[$l_name_default];
    }
}
