<?php

namespace Modules\Main\Entities;

use App\Filters\Filterable;
use App\Filters\QueryFilters;
use Illuminate\Database\Eloquent\Model;

class CCase extends Model
{
    // TODO: replace trait
    use Filterable;

    protected $table = 'cases';
    protected $guarded = ['tags'];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function blocks()
    {
        return $this->hasMany(Block::class, 'entity_id')
            ->where('entity_class', CCase::class)->orderBy('pos');
    }

    public function tags()
    {
        return $this->belongsToMany(Tag::class, 'case_tag', 'case_id');
    }

    public function next(){
        return CCase::where([['pos', '>', $this->pos],['act', 1]])->orderBy('pos','asc')->first();

    }
    public function previous(){
        return CCase::where([['pos', '<', $this->pos],['act', 1]])->orderBy('pos','desc')->first();
    }

    public function getSplitTitleAttribute()
    {
        $k = 0;
        $title = $this->title;
        while(true) {
            $title = trim($title);
            $space = mb_strpos($title, ' ');
            if($space !== false) {
                $title = mb_substr($title, $space);
            }
            $k++;
            if($k>5 || $space === false || mb_strlen($title)/mb_strlen($this->title)<0.59) {
                break;
            }
        }

        if($title != $this->title) {
            $result = [
                trim(mb_substr($this->title, 0, mb_strlen($this->title) - mb_strlen($title))),
                trim(mb_substr($this->title, mb_strlen($this->title) - mb_strlen($title))),
            ];
        } else {
            $result = [$this->title, ''];
        }

        return $result;
    }

}
