<?php

namespace Modules\Main\Entities;

use App\Filters\Filterable;
use App\Filters\QueryFilters;
use Illuminate\Database\Eloquent\Model;

class Block extends Model
{
    protected $guarded = [];

    const TYPE_SIMPLE_TEXT = 0;
    const TYPE_TASK_DECISION = 1;
    const TYPE_RESULT = 2;
    const TYPE_GALLERY = 3;
    const TYPE_VIDEO = 4;

    public static $types = [
        self::TYPE_SIMPLE_TEXT      => 'Простой текст',
        self::TYPE_TASK_DECISION    => 'Задача / решение',
        self::TYPE_RESULT           => 'Результат',
        self::TYPE_GALLERY          => 'Фотогалерея',
        self::TYPE_VIDEO            => 'Видеоролик',
    ];

    /*public function cCase()
    {
        return $this->belongsTo(CCase::class, 'entity_id');
    }

    public function article()
    {
        return $this->belongsTo(Article::class, 'entity_id');
    }*/

    public function owner()
    {
        return $this->belongsTo($this->entity_class, 'entity_id');
    }

    public function images()
    {
        return $this->hasMany(BlockImage::class);
    }

}
