<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBlocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blocks', function (Blueprint $table) {
            $table->increments('id');
            $table->string('entity_class', 191);
            $table->unsignedInteger('entity_id');
            $table->string('title', 191);
            $table->unsignedTinyInteger('type')->default(0);
            $table->string('image', 191)->nullable();
            $table->string('video', 191)->nullable();
            $table->text('content1')->nullable();
            $table->text('content2')->nullable();
            $table->unsignedTinyInteger('pos')->default(0);
            $table->unsignedTinyInteger('act')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blocks');
    }
}
