<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->string('image', 191)->nullable();
            $table->string('link', 191)->nullable();
            $table->unsignedInteger('case_id')->nullable();
            $table->unsignedTinyInteger('pos')->default(0);
            $table->unsignedTinyInteger('act')->default(1);

            $table->foreign('case_id')->on('cases')->references('id')->onDelete('cascade');

        });

        $item = DB::table('modules')->where('name', 'clients')->first();

        if(!$item){
            DB::table('modules')->insert( [
                'name' => 'clients',
                'parent' => '',
                'section' => 'modules',
                'title' => 'Клиенты',
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clients');
    }
}
