<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cases', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title', 191);
            $table->string('slug', 191)->unique();
            $table->string('image', 191)->nullable();
            $table->string('brand', 191)->nullable();
            $table->mediumText('anons')->nullable();
            $table->text('content')->nullable();
            $table->unsignedTinyInteger('pos')->default(0);
            $table->unsignedTinyInteger('act')->default(1);
            $table->timestamps();
        });


        $item = DB::table('modules')->where('name', 'cases')->first();

        if(!$item){
            DB::table('modules')->insert( [
                'name' => 'cases',
                'parent' => 'cases',
                'section' => 'modules',
                'title' => 'Кейсы',
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cases');
    }
}
