<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAboutTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('about', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 191)->unique();
            $table->text('value')->nullable();
        });

        DB::table('about')->insert([
            ['name'  =>  'seo_title'],
            ['name'  =>  'seo_description'],
            ['name'  =>  'seo_keywords'],
            ['name'  =>  'subtitle'],
        ]);

        $item = DB::table('modules')->where('name', 'about')->first();

        if(!$item){
            DB::table('modules')->insert( [
                'name' => 'about',
                'section' => 'modules',
                'title' => 'О компании',
            ]);
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('about');
    }
}
