<?php
namespace Modules\Core\Services;

use Modules\Journals\Entities\Topic;

class MenuService
{

    public static function getMenuItems()
    {
        $topics = Topic::with([
            'columns' => function($query){
                $query->with(['journal'])->where(['menu'=>1,'act'=>1]);
            }
        ])->where(['act' => 1, 'menu' => 1])->orderBy('pos')->get();

        $menu = [];

        foreach($topics as $topic) {
            $menu[$topic->slug] = [
                'title'     => $topic->title,
                'link'      => '#', //'/topics/' . $topic->slug,
                'sub_menu'  => []
            ];

            if(count($topic->columns)) {
                foreach($topic->columns as $column) {
                    if ($column->journal && $column->journal->act) {
                        $menu[$topic->slug]['sub_menu'][] = [
                            'title' => $column->title,
                            'subtitle' =>  $column->journal->published ? $column->journal->title : 'Coming soon',
                            'link' => '/journals/' . $column->journal->slug . '/'
                                . ($column->journal->published ?
                                    ($column->page ? '#book_'.(floor($column->page/2)*2) : '')
                                    : 'anons'
                                ),
                            'class' => $column->journal->published ? '' : 'commingsoon',
                            'modal' => $column->journal->published ? '' : '#commingsoon'
                        ];
                    }
                }
            }
        }

        $menu[] = [
            'title'     => 'Shop GS',
            'link'      => '/store/',
            'sub_menu'  => []
        ];

        return $menu;

    }

}