<?php

namespace Modules\Core\Services;


use App\Notifications\AdminNotify;
use Modules\Callback\Entities\Callback;

class CallbackService
{
    private $logger;
    private $notify;

    public function __construct(AdminNotify $notify)
    {
        $this->notify = $notify;
    }

    public function add(array $data)
    {
        $response['result'] = false;

        try {

            $callback = Callback::create($data);

            $this->notify->notify(new \App\Notifications\CallBack($callback));

            $response['result'] = true;

        } catch (\Exception $e) {
            $response['msg'] = 'Не удалось отправить';
        }

        return $response;
    }

}