<?php

namespace Modules\Core\Http\Composers;

use Illuminate\Contracts\View\View;
use Modules\Modules\Repositories\ModulesRepository;

class AdminMenuComposer
{
    private $modules;

    public function __construct(ModulesRepository $modules)
    {
        $this->modules = $modules;
    }

    public function compose(View $view)
    {
        $view->with('modules', $this->modules->getUserModules(auth()->user()));
        $view->with('sections', $this->modules->sections());
    }

}